"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesService = exports.DEFAULT_SPACE_ID = void 0;
exports.getDefaultSpaceDoc = getDefaultSpaceDoc;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _multitenancy = require("../../../common/multitenancy");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const DEFAULT_SPACE_ID = exports.DEFAULT_SPACE_ID = 'space:default';

// ATTENTION! If either Saved Objects migration or integration with spaces doesn't work,
// check the space document structure in your Kibana version. Maybe it changed.
function getDefaultSpaceDoc(kibanaVersion) {
  return {
    space: {
      name: 'Default',
      description: 'This is your default space!',
      disabledFeatures: [],
      color: '#00bfb3',
      _reserved: true
    },
    type: 'space',
    references: [],
    managed: false,
    typeMigrationVersion: '6.6.0',
    coreMigrationVersion: kibanaVersion,
    updated_at: new Date().toISOString(),
    created_at: new Date().toISOString()
  };
}
class SpacesService {
  constructor({
    kibanaVersion,
    tenantService
  }) {
    (0, _defineProperty2.default)(this, "createDefaultSpace", async ({
      request,
      selectedTenant = _multitenancy.GLOBAL_TENANT_NAME
    } = {}) => {
      const spaceExists = await this.tenantService.docExists({
        request,
        indexName: this.tenantService.aliasName,
        docId: DEFAULT_SPACE_ID
      });
      if (!spaceExists) {
        return this.tenantService.createDoc({
          request,
          tenantName: selectedTenant,
          versionIndexName: this.tenantService.versionIndexName,
          docId: DEFAULT_SPACE_ID,
          docBody: getDefaultSpaceDoc(this.kibanaVersion)
        });
      }
    });
    this.kibanaVersion = kibanaVersion;
    this.tenantService = tenantService;
  }
}
exports.SpacesService = SpacesService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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